/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.gashapon;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.CatmullRomSpline;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import com.megacrit.cardcrawl.vfx.CrystalTrailEffect;
import com.megacrit.cardcrawl.vfx.combat.BossCrystalImpactEffect;
import java.util.ArrayList;

public class BossCrystalEffect
extends AbstractGameEffect {
    private CatmullRomSpline<Vector2> crs = new CatmullRomSpline();
    private ArrayList<Vector2> controlPoints = new ArrayList();
    private static final int TRAIL_ACCURACY = 60;
    private Vector2[] points = new Vector2[60];
    private Vector2 pos;
    private Vector2 target;
    private float particleEmissionTimer;
    private static final float PARTICLE_EMIT_RATE = 0.01f;
    private float backUpTimer;
    private static final float BACK_UP_TIME = 1.5f;
    private static final float FAST_BACK_UP_TIME = 0.2f;
    private float spawnStutterTimer = 0.0f;
    private float currentSpeed = 0.0f;
    private static final float START_VELOCITY = 100.0f * Settings.scale;
    private static final float MAX_VELOCITY = 5000.0f * Settings.scale;
    private static final float VELOCITY_RAMP_RATE = 2000.0f * Settings.scale;
    public boolean isReadyForReuse;
    public boolean isDone;
    private static final float DST_THRESHOLD = 72.0f * Settings.scale;
    private static final float HOME_IN_THRESHOLD = 72.0f * Settings.scale;
    private float rotation;
    private boolean rotateClockwise = true;
    private boolean stopRotating = false;
    private float rotationRate;
    private static final float ROTATION_RATE = 150.0f * Settings.scale;
    private static final float ROTATION_RAMP_RATE = 500.0f;

    public BossCrystalEffect(float x, float y) {
        this.pos = new Vector2(x, y);
        this.target = new Vector2(AbstractDungeon.player.hb.cX - DST_THRESHOLD / 3.0f + MathUtils.random(-30.0f, 30.0f) * Settings.scale, AbstractDungeon.player.hb.cY + MathUtils.random(-50.0f, 50.0f) * Settings.scale);
        this.crs.controlPoints = new Vector2[1];
        this.isReadyForReuse = true;
        this.controlPoints.clear();
        this.rotationRate = ROTATION_RATE * MathUtils.random(1.0f, 2.0f);
        this.stopRotating = false;
        this.rotateClockwise = MathUtils.randomBoolean();
        this.backUpTimer = !CardCrawlGame.fastMode ? 1.5f : 0.2f;
        this.currentSpeed = START_VELOCITY * MathUtils.random(0.2f, 1.0f);
        this.rotation = MathUtils.random(0, 359);
        this.isReadyForReuse = false;
        this.isDone = false;
        this.particleEmissionTimer = 0.0f;
        this.controlPoints.clear();
        this.rotationRate = ROTATION_RATE * MathUtils.random(1.0f, 2.0f);
        this.stopRotating = false;
        this.rotateClockwise = MathUtils.randomBoolean();
        this.backUpTimer = !CardCrawlGame.fastMode ? 1.5f : 0.2f;
        this.currentSpeed = START_VELOCITY * MathUtils.random(0.2f, 1.0f);
        this.rotation = MathUtils.random(0, 359);
        this.isReadyForReuse = false;
        this.isDone = false;
        this.particleEmissionTimer = 0.0f;
    }

    @Override
    public void update() {
        if (this.spawnStutterTimer > 0.0f) {
            this.spawnStutterTimer -= Gdx.graphics.getDeltaTime();
            return;
        }
        this.particleEmissionTimer -= Gdx.graphics.getDeltaTime();
        if (this.particleEmissionTimer <= 0.0f) {
            this.particleEmissionTimer = 0.01f;
        }
        this.updateMovement();
        this.updateBackUpTimer();
        if (this.isDone) {
            // empty if block
        }
    }

    private void updateMovement() {
        Vector2 tmp = new Vector2(this.pos.x - this.target.x, this.pos.y - this.target.y);
        tmp.nor();
        float targetAngle = tmp.angle();
        this.rotationRate += Gdx.graphics.getDeltaTime() * 500.0f;
        if (!this.stopRotating) {
            if (this.rotateClockwise) {
                this.rotation += Gdx.graphics.getDeltaTime() * this.rotationRate;
            } else {
                this.rotation -= Gdx.graphics.getDeltaTime() * this.rotationRate;
                if (this.rotation < 0.0f) {
                    this.rotation += 360.0f;
                }
            }
            this.rotation %= 360.0f;
            if (!this.stopRotating) {
                if (this.target.dst(this.pos) < HOME_IN_THRESHOLD) {
                    this.rotation = targetAngle;
                    this.stopRotating = true;
                } else if (Math.abs(this.rotation - targetAngle) < Gdx.graphics.getDeltaTime() * this.rotationRate) {
                    this.rotation = targetAngle;
                    this.stopRotating = true;
                }
            }
        }
        tmp.setAngle(this.rotation);
        tmp.x *= Gdx.graphics.getDeltaTime() * this.currentSpeed;
        tmp.y *= Gdx.graphics.getDeltaTime() * this.currentSpeed;
        this.pos.sub(tmp);
        this.currentSpeed = this.stopRotating && this.backUpTimer < 1.3499999f ? (this.currentSpeed += Gdx.graphics.getDeltaTime() * VELOCITY_RAMP_RATE * 3.0f) : (this.currentSpeed += Gdx.graphics.getDeltaTime() * VELOCITY_RAMP_RATE * 1.5f);
        if (this.currentSpeed > MAX_VELOCITY) {
            this.currentSpeed = MAX_VELOCITY;
        }
        if (this.target.x < (float)Settings.WIDTH / 2.0f && this.pos.x < 0.0f) {
            if (!this.isDone) {
                this.isDone = true;
                AbstractDungeon.effectsQueue.add(new BossCrystalImpactEffect(this.target.x, this.target.y));
            }
        } else if (this.target.x > (float)Settings.WIDTH / 2.0f && this.pos.x > (float)Settings.WIDTH && !this.isDone) {
            this.isDone = true;
            AbstractDungeon.effectsQueue.add(new BossCrystalImpactEffect(this.target.x, this.target.y));
        }
        if (this.target.dst(this.pos) < DST_THRESHOLD && !this.isDone) {
            this.isDone = true;
            AbstractDungeon.effectsQueue.add(new BossCrystalImpactEffect(this.target.x, this.target.y));
        }
        if (!this.isDone) {
            if (!this.controlPoints.isEmpty()) {
                if (!this.controlPoints.get(0).equals(this.pos)) {
                    this.controlPoints.add(this.pos.cpy());
                }
            } else {
                this.controlPoints.add(this.pos.cpy());
            }
            if (this.controlPoints.size() > 10) {
                this.controlPoints.remove(0);
            }
            if (this.controlPoints.size() > 3) {
                Vector2[] vec2Array = new Vector2[]{};
                this.crs.set(this.controlPoints.toArray(vec2Array), false);
                for (int i = 0; i < 60; ++i) {
                    this.points[i] = new Vector2();
                    Vector2 derp = this.crs.valueAt(this.points[i], (float)i / 59.0f);
                    AbstractDungeon.topLevelEffects.add(new CrystalTrailEffect(derp.x, derp.y, this.rotation));
                }
            }
        }
    }

    private void updateBackUpTimer() {
        this.backUpTimer -= Gdx.graphics.getDeltaTime();
        if (this.backUpTimer < 0.0f && !this.isDone) {
            this.isDone = true;
            AbstractDungeon.effectsQueue.add(new BossCrystalImpactEffect(this.target.x, this.target.y));
        }
    }

    @Override
    public void render(SpriteBatch sb) {
    }
}

